/*
 * Decompiled with CFR 0.152.
 */
package com.vinlanx.gunfireoverhaul;

import com.mojang.logging.LogUtils;
import com.vinlanx.gunfireoverhaul.AmbientGunfireManager;
import com.vinlanx.gunfireoverhaul.Config;
import com.vinlanx.gunfireoverhaul.ModSounds;
import com.vinlanx.gunfireoverhaul.PacketHandler;
import com.vinlanx.gunfireoverhaul.TacZIntegrationHandler;
import com.vinlanx.gunfireoverhaul.client.ClientSetup;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="gunfireoverhaul")
public class GunfireOverhaul {
    public static final String MODID = "gunfireoverhaul";
    public static final Logger LOGGER = LogUtils.getLogger();

    public GunfireOverhaul() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON_SPEC);
        ModSounds.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register(TacZIntegrationHandler.class);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ClientSetup::registerClientOnly);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(PacketHandler::register);
        LOGGER.info("Gunfire Overhaul common setup complete.");
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.getServer().m_129783_() != null) {
            AmbientGunfireManager.onServerTick((Level)event.getServer().m_129783_());
        }
    }
}

